
# Magnetometer Vector Magnitude App Note Example

import FXOS8700CQ
import aardvark_setup
from aardvark_py import *
from utils import *
import time
import math
from config import *

# Print Revision

print "AN4458 SW Rev: " + str(REVISION)

# Setup Aardvark

(handle, INT1_PIN) = aardvark_setup.setup_aardvark()

# Update aardvark handle in FXOS8700CQ.py

FXOS8700CQ.handle = handle

# Reset 

FXOS8700CQ.reset_FXOS8700CQ()

# Initialize reference vector

refMagX = refMagXHi = refMagXLo = 0
refMagY = refMagYHi = refMagYLo = 0
refMagZ = refMagZHi = refMagZLo = 0

# Initialize min/max for hard iron estimate

magXMax = magYMax = magZMax = int16( 0x8000 )
magXMin = magYMin = magZMin = int16( 0x7FFF )

# Set threshold. 1000 counts = 100.0uT

magThreshold = 1000 # counts
magThresholdHi = (magThreshold & 0xFF00) >> 8
magThresholdLo = magThreshold & 0xFF

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6A, 0x80 | magThresholdHi] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6B, magThresholdLo] )

# M_VECM_CNT = 1 * 20ms  = 20ms
# ! - steps double in hybrid mode

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6C, 0x01] )

# M_VECM_INIT_X_MSB...Z_LSB = refMagX/Y/Z

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6D, refMagXHi] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6E, refMagXLo] )

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6F, refMagYHi] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x70, refMagYLo] )

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x71, refMagZHi] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x72, refMagZLo] )

# M_VECM_CFG
# m_vecm_ele = 1 => event latching enabled
# m_vecm_initm = 1 => use M_VECM_INITX/Y/Z as initial reference
# m_vecm_updm = 1 => do not update initial reference
# m_vecm_en = 1 => enable magnetometer vector magnitude detection feature

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x69, 0x7B] )

# enable interrupts for DRDY using CTRL_REG4

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2D, 0x01] )

# route interrupts to INT1 pin using CTRL_REG5

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2E, 0x01] )

# Setup device for hybrid mode, enable hybrid mode auto-increment, 
# ODR = 6.25Hz, OSR=256, go to ACTIVE mode using M_CTRL_REG1, M_CTRL_REG2 and
# CTRL_REG1

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5B, 0x1F] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5C, 0x20] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2A, 0x29] )

# Wait for INT1 to assert and clear interrupt by reading register 
# INT_SOURCE (0x0C) or reading sensor data (0x01...0x06, 0x33...0x38)
# depending on the function that generated the interrupt

while( True ):
    
    transition = aa_gpio_change( handle, 100 )
    if (transition & INT1_PIN ) == INT1_PIN:
        #print "No interrupt..."
        continue			
        
    print "\nODR cycle ==============>\n"

    (count, dataIn) = FXOS8700CQ.read_FXOS8700CQ( 0x5E, 1 )
        
    if dataIn[0] & 0x02 == 0x02:
        
        print "Interrupt due to Magnetometer Vector Magnitude feature"
        print "Magnetic Jamming detected, resetting hard iron estimate..."

        # Reset hard iron estimate
                
        magXMax = magYMax = magZMax = int16( 0x8000 )
        magXMin = magYMin = magZMin = int16( 0x7FFF )
            
    (count, dataIn) = FXOS8700CQ.read_FXOS8700CQ( 0x0C, 1 )
        
    if dataIn[0] & 0x01 == 0x01:
        
        print "Interrupt due to data ready"
                
        (magX, magY, magZ, accX, accY, accZ) = FXOS8700CQ.FXOS8700CQ_display_sens_data()

        # Calculate VECM

        magnitude = math.sqrt( math.pow( (magX - refMagX), 2) + 
                math.pow( (magY - refMagY), 2) + math.pow( (magZ - refMagZ), 2) )
                
        print "Magnetometer Vector Magnitude = %f uT" % (magnitude / 10)
            
        if magnitude > magThreshold:
                
            print "Magnetometer Vector Magnitude interrupt should have been triggered"

        # Finally calculate new hard iron estimate and put in reference
        # registers
                
        if magX < magXMin:

            magXMin = magX

        if magY < magYMin:

            magYMin = magY

        if magZ < magZMin:

            magZMin = magZ
                
        if magX > magXMax:

            magXMax = magX

        if magY > magYMax:

            magYMax = magY

        if magZ > magZMax:

            magZMax = magZ

        refMagX = (magXMax + magXMin) / 2
        refMagY = (magYMax + magYMin) / 2
        refMagZ = (magZMax + magZMin) / 2

        print "refMagX = %d, refMagY = %d, refMagZ = %d" % (refMagX, refMagY, refMagZ)

        refMagXHi = (refMagX & 0xFF00) >> 8
        refMagXLo = (refMagX & 0x00FF) 

        refMagYHi = (refMagY & 0xFF00) >> 8
        refMagYLo = (refMagY & 0x00FF)

        refMagZHi = (refMagZ & 0xFF00) >> 8
        refMagZLo = (refMagZ & 0x00FF)

        # M_VECM_INIT_X_MSB...Z_LSB = refMagX/Y/Z

        FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6D, refMagXHi] )
        FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6E, refMagXLo] )

        FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6F, refMagYHi] )
        FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x70, refMagYLo] )

        FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x71, refMagZHi] )
        FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x72, refMagZLo] )
        
    else:
        
        print "unexpected interrupt"
